import { getDictionary, Locale } from "@/lib/i18n";
import { Hero } from "@/components/sections/Hero";
import { ProductEcosystem } from "@/components/sections/ProductEcosystem";
import { CTA } from "@/components/sections/CTA";

export default async function Home({
  params: { lang },
}: {
  params: { lang: Locale };
}) {
  const dictionary = await getDictionary(lang);

  return (
    <div className="flex flex-col min-h-screen">
      <Hero dict={dictionary.home.hero} />
      <ProductEcosystem dict={dictionary.home.ecosystem} />
      <CTA dict={dictionary.home.cta} />
    </div>
  );
}
